/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.chunk;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.internal.base.ComponentsInternals;
import dev.onyxstudios.cca.internal.chunk.CardinalComponentsChunk;
import java.util.Objects;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class CcaChunkClient {
    public static void initClient() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)CardinalComponentsChunk.PACKET_ID, (client, handler, buffer, res) -> {
                try {
                    int chunkX = buffer.readInt();
                    int chunkZ = buffer.readInt();
                    class_2960 componentTypeId = buffer.method_10810();
                    ComponentKey componentType = ComponentRegistry.get((class_2960)componentTypeId);
                    if (componentType == null) {
                        return;
                    }
                    buffer.retain();
                    client.execute(() -> {
                        try {
                            componentType.maybeGet((Object)Objects.requireNonNull(client.field_1687).method_8497(chunkX, chunkZ)).filter(c -> c instanceof AutoSyncedComponent).ifPresent(c -> ((AutoSyncedComponent)c).applySyncPacket(buffer));
                        }
                        finally {
                            buffer.release();
                        }
                    });
                }
                catch (Exception e) {
                    ComponentsInternals.LOGGER.error("Error while reading chunk components from network", (Throwable)e);
                    throw e;
                }
            });
        }
        if (FabricLoader.getInstance().isModLoaded("fabric-lifecycle-events-v1")) {
            ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> ((ComponentProvider)chunk).getComponentContainer().onServerLoad());
            ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> ((ComponentProvider)chunk).getComponentContainer().onServerUnload());
        }
    }
}

